import sql from 'mssql';
import { config } from './config.js';

const findAuthorsByBirthDates = async (startDate, endDate) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Call the stored procedure GetAuthorsByBirthDate
    const result = await pool
      .request()
      .input('StartDate', sql.Date, new Date(startDate))
      .input('EndDate', sql.Date, new Date(endDate))
      .execute('GetAuthorsByBirthDate');

    // Return the result
    return result.recordset;
  } catch (err) {
    console.error(err);
  }
};

const findAuthorsByBirthYears = async (startYear, endYear) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Call the stored procedure GetAuthorsByBirthYear
    const result = await pool
      .request()
      .input('StartYear', sql.SmallInt, startYear)
      .input('EndYear', sql.SmallInt, endYear)
      .output('AuthorCount', sql.Int)
      .execute('GetAuthorsByBirthYear');

    // Return the result
    return result;
  } catch (err) {
    console.error(err);
  }
};

export { findAuthorsByBirthDates, findAuthorsByBirthYears };
